/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.JDONullIdentityException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.persistence.PersistenceException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.jpa.JPAPersistenceManager;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.api.jpa.state.LifeCycleStateFactory;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPAAdapter
implements ApiAdapter {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());

    public String getName() {
        return "JPA";
    }

    public boolean isManaged(Object pc) {
        return this.getExecutionContext(pc) != null;
    }

    public ExecutionContext getExecutionContext(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof PersistenceCapable) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (pm == null) {
                return null;
            }
            return ((JPAPersistenceManager)pm).getExecutionContext();
        }
        if (obj instanceof PersistenceManager) {
            return ((JPAPersistenceManager)obj).getExecutionContext();
        }
        return null;
    }

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public boolean isPersistent(Object obj) {
        return JDOHelper.isPersistent((Object)obj);
    }

    public boolean isNew(Object obj) {
        return JDOHelper.isNew((Object)obj);
    }

    public boolean isDirty(Object obj) {
        return JDOHelper.isDirty((Object)obj);
    }

    public boolean isDeleted(Object obj) {
        return JDOHelper.isDeleted((Object)obj);
    }

    public boolean isDetached(Object obj) {
        return JDOHelper.isDetached((Object)obj);
    }

    public boolean isTransactional(Object obj) {
        return JDOHelper.isTransactional((Object)obj);
    }

    public boolean isPersistable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof PersistenceCapable;
    }

    public boolean isPersistable(Class cls) {
        if (cls == null) {
            return false;
        }
        return PersistenceCapable.class.isAssignableFrom(cls);
    }

    public boolean isDetachable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Detachable;
    }

    public String getObjectState(Object obj) {
        return JDOHelper.getObjectState((Object)obj).toString();
    }

    public void makeDirty(Object obj, String member) {
        ((PersistenceCapable)obj).jdoMakeDirty(member);
    }

    public Object getIdForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((PersistenceCapable)obj).jdoGetObjectId();
    }

    public Object getVersionForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((PersistenceCapable)obj).jdoGetVersion();
    }

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields, MetaDataManager mmgr) {
        return true;
    }

    public boolean isSingleFieldIdentity(Object id) {
        return id instanceof SingleFieldIdentity;
    }

    public boolean isDatastoreIdentity(Object id) {
        return id != null && id instanceof OID;
    }

    public boolean isSingleFieldIdentityClass(String className) {
        if (className == null || className.length() < 1) {
            return false;
        }
        return className.equals(this.getSingleFieldIdentityClassNameForByte()) || className.equals(this.getSingleFieldIdentityClassNameForChar()) || className.equals(this.getSingleFieldIdentityClassNameForInt()) || className.equals(this.getSingleFieldIdentityClassNameForLong()) || className.equals(this.getSingleFieldIdentityClassNameForObject()) || className.equals(this.getSingleFieldIdentityClassNameForShort()) || className.equals(this.getSingleFieldIdentityClassNameForString());
    }

    public String getSingleFieldIdentityClassNameForLong() {
        return LongIdentity.class.getName();
    }

    public String getSingleFieldIdentityClassNameForInt() {
        return IntIdentity.class.getName();
    }

    public String getSingleFieldIdentityClassNameForShort() {
        return ShortIdentity.class.getName();
    }

    public String getSingleFieldIdentityClassNameForByte() {
        return ByteIdentity.class.getName();
    }

    public String getSingleFieldIdentityClassNameForChar() {
        return CharIdentity.class.getName();
    }

    public String getSingleFieldIdentityClassNameForString() {
        return StringIdentity.class.getName();
    }

    public String getSingleFieldIdentityClassNameForObject() {
        return ObjectIdentity.class.getName();
    }

    public Class getTargetClassForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getTargetClass();
        }
        return null;
    }

    public String getTargetClassNameForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getTargetClassName();
        }
        return null;
    }

    public Object getTargetKeyForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getKeyAsObject();
        }
        return null;
    }

    public Class getKeyTypeForSingleFieldIdentityType(Class idType) {
        if (idType == null) {
            return null;
        }
        if (!this.isSingleFieldIdentityClass(idType.getName())) {
            return null;
        }
        if (LongIdentity.class.isAssignableFrom(idType)) {
            return Long.class;
        }
        if (IntIdentity.class.isAssignableFrom(idType)) {
            return Integer.class;
        }
        if (ShortIdentity.class.isAssignableFrom(idType)) {
            return Short.class;
        }
        if (ByteIdentity.class.isAssignableFrom(idType)) {
            return Byte.class;
        }
        if (CharIdentity.class.isAssignableFrom(idType)) {
            return Character.class;
        }
        if (StringIdentity.class.isAssignableFrom(idType)) {
            return String.class;
        }
        if (ObjectIdentity.class.isAssignableFrom(idType)) {
            return Object.class;
        }
        return null;
    }

    public Object getNewSingleFieldIdentity(Class idType, Class pcType, Object value) {
        if (idType == null) {
            throw new NucleusException(LOCALISER.msg("029001", (Object)pcType)).setFatal();
        }
        if (pcType == null) {
            throw new NucleusException(LOCALISER.msg("029000", (Object)idType)).setFatal();
        }
        if (value == null) {
            throw new NucleusException(LOCALISER.msg("029003", (Object)idType, (Object)pcType)).setFatal();
        }
        if (!SingleFieldIdentity.class.isAssignableFrom(idType)) {
            throw new NucleusException(LOCALISER.msg("029002", (Object)idType.getName(), (Object)pcType.getName())).setFatal();
        }
        SingleFieldIdentity id = null;
        Class keyType = null;
        if (idType == LongIdentity.class) {
            keyType = Long.class;
            if (!(value instanceof Long)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Long")).setFatal();
            }
        } else if (idType == IntIdentity.class) {
            keyType = Integer.class;
            if (!(value instanceof Integer)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Integer")).setFatal();
            }
        } else if (idType == StringIdentity.class) {
            keyType = String.class;
            if (!(value instanceof String)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"String")).setFatal();
            }
        } else if (idType == ByteIdentity.class) {
            keyType = Byte.class;
            if (!(value instanceof Byte)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Byte")).setFatal();
            }
        } else if (idType == ShortIdentity.class) {
            keyType = Short.class;
            if (!(value instanceof Short)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Short")).setFatal();
            }
        } else if (idType == CharIdentity.class) {
            keyType = Character.class;
            if (!(value instanceof Character)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Character")).setFatal();
            }
        } else {
            keyType = Object.class;
        }
        try {
            Class[] ctrArgs = new Class[]{Class.class, keyType};
            Constructor ctr = idType.getConstructor(ctrArgs);
            Object[] args = new Object[]{pcType, value};
            id = (SingleFieldIdentity)ctr.newInstance(args);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Error encountered while creating SingleFieldIdentity instance of type \"" + idType.getName() + "\""));
            NucleusLogger.PERSISTENCE.error((Object)e);
            return null;
        }
        return id;
    }

    public Object getNewApplicationIdentityObjectId(ClassLoaderResolver clr, AbstractClassMetaData acmd, String value) {
        if (acmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusException("This class (" + acmd.getFullClassName() + ") doesn't use application-identity!");
        }
        Class targetClass = clr.classForName(acmd.getFullClassName());
        Class idType = clr.classForName(acmd.getObjectidClass());
        Object id = null;
        if (acmd.usesSingleFieldIdentityClass()) {
            try {
                Class[] ctrArgs = ObjectIdentity.class.isAssignableFrom(idType) ? new Class[]{Class.class, Object.class} : new Class[]{Class.class, String.class};
                Constructor ctr = idType.getConstructor(ctrArgs);
                Object[] args = new Object[]{targetClass, value};
                id = ctr.newInstance(args);
            }
            catch (Exception e) {
                throw new NucleusException("Error encountered while creating SingleFieldIdentity instance with key \"" + value + "\"", (Throwable)e);
            }
        } else if (Modifier.isAbstract(targetClass.getModifiers()) && acmd.getObjectidClass() != null) {
            try {
                Constructor c = clr.classForName(acmd.getObjectidClass()).getDeclaredConstructor(String.class);
                id = c.newInstance(value);
            }
            catch (Exception e) {
                String msg = LOCALISER.msg("010030", (Object)acmd.getObjectidClass(), (Object)acmd.getFullClassName());
                NucleusLogger.PERSISTENCE.error((Object)msg);
                NucleusLogger.PERSISTENCE.error((Object)e);
                throw new NucleusUserException(msg);
            }
        } else {
            clr.classForName(targetClass.getName(), true);
            id = NucleusJPAHelper.getJDOImplHelper().newObjectIdInstance(targetClass, (Object)value);
        }
        return id;
    }

    public Object getNewApplicationIdentityObjectId(Object pc, AbstractClassMetaData cmd) {
        if (pc == null || cmd == null) {
            return null;
        }
        try {
            Object id = ((PersistenceCapable)pc).jdoNewObjectIdInstance();
            if (!cmd.usesSingleFieldIdentityClass()) {
                ((PersistenceCapable)pc).jdoCopyKeyFieldsToObjectId(id);
            }
            return id;
        }
        catch (JDONullIdentityException nie) {
            return null;
        }
    }

    public Object getNewApplicationIdentityObjectId(Class cls, Object key) {
        return NucleusJPAHelper.getJDOImplHelper().newObjectIdInstance(cls, key);
    }

    public boolean allowPersistOfDeletedObject() {
        return true;
    }

    public boolean allowDeleteOfNonPersistentObject() {
        return true;
    }

    public boolean allowReadFieldOfDeletedObject() {
        return true;
    }

    public boolean clearLoadedFlagsOnDeleteObject() {
        return false;
    }

    public boolean getDefaultCascadePersistForField() {
        return false;
    }

    public boolean getDefaultCascadeUpdateForField() {
        return false;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public Map getDefaultFactoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("datanucleus.DetachAllOnCommit", "true");
        props.put("datanucleus.DetachAllOnRollback", "true");
        props.put("datanucleus.RetainValues", "true");
        props.put("datanucleus.Optimistic", "true");
        props.put("datanucleus.nontx.atomic", "false");
        props.put("datanucleus.metadata.allowLoadAtRuntime", "false");
        props.put("datanucleus.identifierFactory", "jpa");
        props.put("datanucleus.persistenceByReachabilityAtCommit", "false");
        props.put("datanucleus.manageRelationships", "false");
        props.put("datanucleus.manageRelationshipsChecks", "false");
        props.put("datanucleus.rdbms.stringDefaultLength", "255");
        props.put("datanucleus.query.sql.allowAll", "true");
        props.put("datanucleus.maxFetchDepth", "-1");
        props.put("datanucleus.findObject.validateWhenCached", "false");
        return props;
    }

    public Object getObjectId(ObjectProvider sm) {
        return sm.getObjectId();
    }

    public Object getVersion(ObjectProvider sm) {
        return sm.getVersion();
    }

    public boolean isLoaded(ObjectProvider sm, int fieldNumber) {
        return sm.isLoaded(fieldNumber);
    }

    public RuntimeException getUserExceptionForException(String msg, Exception e) {
        return new PersistenceException(msg, (Throwable)e);
    }

    public RuntimeException getDataStoreExceptionForException(String msg, Exception e) {
        return new PersistenceException(msg, (Throwable)e);
    }

    public RuntimeException getApiExceptionForNucleusException(NucleusException ne) {
        return NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
    }

    public Object getCopyOfPersistableObject(Object obj, ObjectProvider sm, int[] fieldNumbers) {
        PersistenceCapable pc = (PersistenceCapable)obj;
        PersistenceCapable copy = pc.jdoNewInstance((StateManager)sm);
        copy.jdoCopyFields((Object)pc, fieldNumbers);
        return copy;
    }

    public void copyFieldsFromPersistableObject(Object pc, int[] fieldNumbers, Object pc2) {
        ((PersistenceCapable)pc2).jdoCopyFields(pc, fieldNumbers);
    }
}

