/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.reflect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;

@GoogleInternal
class NotAnnotatedElement
implements AnnotatedElement {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    NotAnnotatedElement() {
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        Preconditions.checkNotNull(clazz);
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Preconditions.checkNotNull(annotationClass);
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return EMPTY_ANNOTATION_ARRAY;
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.getDeclaredAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return EMPTY_ANNOTATION_ARRAY;
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        Preconditions.checkNotNull(annotationClass);
        return null;
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }
}

