/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import java.util.Objects;

public class ApiNamespaceConfig {
    private String ownerDomain;
    private String ownerName;
    private String packagePath;

    public ApiNamespaceConfig() {
        this.setDefaults();
    }

    public ApiNamespaceConfig(ApiNamespaceConfig original) {
        this.ownerDomain = original.ownerDomain;
        this.ownerName = original.ownerName;
        this.packagePath = original.packagePath;
    }

    protected void setDefaults() {
        this.ownerDomain = "";
        this.ownerName = "";
        this.packagePath = "";
    }

    public void setOwnerDomain(String ownerDomain) {
        this.ownerDomain = ownerDomain;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getOwnerDomain() {
        return this.ownerDomain;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiNamespaceConfig)) {
            return false;
        }
        ApiNamespaceConfig that = (ApiNamespaceConfig)o;
        return Iterables.isEmpty(this.getConfigurationInconsistencies(that));
    }

    public Iterable<ApiConfigInconsistency<String>> getConfigurationInconsistencies(ApiNamespaceConfig config) {
        return ApiConfigInconsistency.listBuilder().addIfInconsistent("namespace.ownerDomain", this.ownerDomain, config.ownerDomain).addIfInconsistent("namespace.ownerName", this.ownerName, config.ownerName).addIfInconsistent("namespace.packagePath", this.packagePath, config.packagePath).build();
    }

    public int hashCode() {
        return Objects.hash(this.ownerDomain, this.ownerName, this.packagePath);
    }
}

