/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.auth.AuthUtils;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class AppEngineAuthUtils {
    private static final Logger logger = Logger.getLogger(AppEngineAuthUtils.class.getName());
    private final boolean clientIdWhitelistEnabled;
    private final HttpRequestFactory httpRequestFactory;

    AppEngineAuthUtils(boolean clientIdWhitelistEnabled) {
        this.clientIdWhitelistEnabled = clientIdWhitelistEnabled;
        this.httpRequestFactory = AuthUtils.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) {
                request.setParser(new JsonObjectParser(AuthUtils.getJsonFactory()));
            }
        });
    }

    public User getCurrentUser(String token, ApiMethodConfig methodConfig) {
        List<String> allowedClientIds = methodConfig.getClientIds();
        return this.getCurrentUser(token, methodConfig.getScopeExpression(), allowedClientIds, SystemProperty.environment.value());
    }

    @VisibleForTesting
    User getCurrentUser(String token, AuthScopeExpression scopeExpression, List<String> allowedClientIds) {
        return this.getCurrentUser(token, scopeExpression, allowedClientIds, SystemProperty.Environment.Value.Production);
    }

    @VisibleForTesting
    User getCurrentUser(String token, AuthScopeExpression scopeExpression, List<String> allowedClientIds, SystemProperty.Environment.Value env) {
        String clientId;
        logger.log(Level.FINE, "token={0}", token);
        logger.log(Level.FINE, "scopeExpression={0}", scopeExpression.toLoggingForm());
        logger.log(Level.FINE, "allowedClientIds={0}", allowedClientIds);
        String[] allScopes = scopeExpression.getAllScopes();
        if (env == SystemProperty.Environment.Value.Development) {
            clientId = this.getOAuth2ClientIdDev(token);
        } else {
            try {
                Object[] authorizedScopes = this.getOAuth2AuthorizedScopes(allScopes);
                boolean authorized = false;
                if (authorizedScopes != null) {
                    authorized = scopeExpression.isAuthorized((Set<String>)ImmutableSet.copyOf((Object[])authorizedScopes));
                }
                if (!authorized) {
                    logger.info("getCurrentUser: AccessToken; scope not allowed");
                    return null;
                }
                clientId = this.getOAuth2ClientId(allScopes);
            }
            catch (OAuthRequestException e) {
                String string = String.valueOf(String.valueOf(scopeExpression));
                logger.log(Level.INFO, new StringBuilder(75 + string.length()).append("getCurrentUser: AccessToken; Tried and failed to get client id for scope '").append(string).append("'").toString(), e);
                return null;
            }
        }
        if (!AuthUtils.isClientIdAllowed(this.clientIdWhitelistEnabled, clientId, allowedClientIds, true)) {
            logger.log(Level.WARNING, "getCurrentUser: clientId {0} not allowed", clientId);
            return null;
        }
        try {
            User user = this.getOAuth2User(allScopes);
            logger.log(Level.INFO, "getCurrentUser: AccessToken; user={0}", user);
            return user;
        }
        catch (OAuthRequestException e) {
            String string = String.valueOf(String.valueOf(scopeExpression.toLoggingForm()));
            logger.log(Level.INFO, new StringBuilder(81 + string.length()).append("getCurrentUser: AccessToken; Tried and failed to get user for scope expression '").append(string).append("'").toString(), e);
            logger.info("getCurrentUser: AccessToken; scope not allowed");
            return null;
        }
    }

    @VisibleForTesting
    User getOAuth2User(String[] scopes) throws OAuthRequestException {
        return OAuthServiceFactory.getOAuthService().getCurrentUser(scopes);
    }

    @VisibleForTesting
    String getOAuth2ClientId(String[] scopes) throws OAuthRequestException {
        return OAuthServiceFactory.getOAuthService().getClientId(scopes);
    }

    @VisibleForTesting
    String[] getOAuth2AuthorizedScopes(String[] scopes) throws OAuthRequestException {
        return OAuthServiceFactory.getOAuthService().getAuthorizedScopes(scopes);
    }

    @VisibleForTesting
    String getOAuth2ClientIdDev(String token) {
        try {
            HttpHeaders headers = new HttpHeaders();
            String string = String.valueOf(token);
            headers.setAuthorization(string.length() != 0 ? "Bearer ".concat(string) : new String("Bearer "));
            GenericUrl url = new GenericUrl("https://www.google.com/accounts/AuthSubTokenInfo");
            HttpRequest request = this.httpRequestFactory.buildGetRequest(url).setHeaders(headers);
            HttpResponse response = request.execute();
            Properties properties = new Properties();
            properties.load(response.getContent());
            return (String)properties.get("Target");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to retrieve clientId from access token", e);
            return null;
        }
    }

    @VisibleForTesting
    User getCookieUser() {
        return UserServiceFactory.getUserService().getCurrentUser();
    }
}

