/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Transaction;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TransactionCleanupFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(TransactionCleanupFilter.class.getName());
    private DatastoreService datastoreService;

    public void init(FilterConfig filterConfig) {
        this.datastoreService = this.getDatastoreService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            Collection<Transaction> txns = this.datastoreService.getActiveTransactions();
            if (!txns.isEmpty()) {
                this.handleAbandonedTxns(txns);
            }
        }
    }

    void handleAbandonedTxns(Collection<Transaction> txns) {
        for (Transaction txn : txns) {
            try {
                String string = String.valueOf(String.valueOf(txn.getId()));
                logger.warning(new StringBuilder(108 + string.length()).append("Request completed without committing or rolling back transaction with id ").append(string).append(".  Transaction will be rolled back.").toString());
                txn.rollback();
            }
            catch (Exception e) {
                String string = String.valueOf("Swallowing an exception we received while trying to rollback abandoned transaction with id ");
                String string2 = String.valueOf(txn.getId());
                logger.log(Level.SEVERE, string2.length() != 0 ? string.concat(string2) : new String(string), e);
            }
        }
    }

    public void destroy() {
        this.datastoreService = null;
    }

    DatastoreService getDatastoreService() {
        return DatastoreServiceFactory.getDatastoreService();
    }
}

