/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.remoteapi;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteApiServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(RemoteApiServlet.class.getName());
    private static final String OAUTH_SCOPE = "https://www.googleapis.com/auth/appengine.apis";
    private static final String ALLOW_OAUTH_INIT_PARAM = "_allowOAuth";
    private static final String INBOUND_APP_SYSTEM_PROPERTY = "HTTP_X_APPENGINE_INBOUND_APPID";
    private static final String INBOUND_APP_HEADER_NAME = "X-AppEngine-Inbound-AppId";
    private HashSet<String> allowedApps = null;
    private final OAuthService oauthService;
    private boolean allowOAuth = false;

    public RemoteApiServlet() {
        this(OAuthServiceFactory.getOAuthService());
    }

    RemoteApiServlet(OAuthService oauthService) {
        this.oauthService = oauthService;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String allowOAuthParam = servletConfig.getInitParameter(ALLOW_OAUTH_INIT_PARAM);
        if (allowOAuthParam != null) {
            this.allowOAuth = RemoteApiServlet.toBoolean(allowOAuthParam);
        }
    }

    private static boolean toBoolean(String initParam) {
        return (initParam = initParam.trim()).equalsIgnoreCase("true") || initParam.equals("1");
    }

    boolean checkIsValidRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsKnownInbound(req) && !this.checkIsAdmin(req, res)) {
            return false;
        }
        return this.checkIsValidHeader(req, res);
    }

    private synchronized boolean checkIsKnownInbound(HttpServletRequest req) throws IOException {
        String inboundAppId;
        if (this.allowedApps == null) {
            this.allowedApps = new HashSet();
            String allowedAppsStr = System.getProperty(INBOUND_APP_SYSTEM_PROPERTY);
            if (allowedAppsStr != null) {
                String[] apps;
                for (String app : apps = allowedAppsStr.split(",")) {
                    this.allowedApps.add(app);
                }
            }
        }
        return (inboundAppId = req.getHeader(INBOUND_APP_HEADER_NAME)) != null && this.allowedApps.contains(inboundAppId);
    }

    private boolean checkIsValidHeader(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getHeader("X-appcfg-api-version") == null) {
            res.setStatus(403);
            res.setContentType("text/plain");
            res.getWriter().println("This request did not contain a necessary header");
            return false;
        }
        return true;
    }

    private boolean checkIsAdmin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UserService userService = UserServiceFactory.getUserService();
        if (userService.getCurrentUser() != null) {
            if (userService.isUserAdmin()) {
                return true;
            }
            this.respondNotAdmin(res);
            return false;
        }
        if (this.allowOAuth) {
            try {
                if (this.oauthService.isUserAdmin(OAUTH_SCOPE)) {
                    return true;
                }
                this.respondNotAdmin(res);
                return false;
            }
            catch (OAuthRequestException e) {
                // empty catch block
            }
        }
        res.sendRedirect(userService.createLoginURL(req.getRequestURI()));
        return false;
    }

    private void respondNotAdmin(HttpServletResponse res) throws IOException {
        res.setStatus(401);
        res.setContentType("text/plain");
        res.getWriter().println("You must be logged in as an administrator, or access from an approved application.");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsValidRequest(req, res)) {
            return;
        }
        res.setContentType("text/plain");
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        StringBuilder outYaml = new StringBuilder().append("{rtok: ").append(req.getParameter("rtok")).append(", app_id: ").append(appId).append("}");
        res.getWriter().println(outYaml);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RemoteApiPb.Response response;
        block3: {
            if (!this.checkIsValidRequest(req, res)) {
                return;
            }
            res.setContentType("application/octet-stream");
            response = new RemoteApiPb.Response();
            try {
                byte[] responseData = this.executeRequest(req);
                response.setResponseAsBytes(responseData);
                res.setStatus(200);
            }
            catch (Exception e) {
                String string = String.valueOf(String.valueOf(e));
                log.warning(new StringBuilder(53 + string.length()).append("Caught exception while executing remote_api command:\n").append(string).toString());
                res.setStatus(200);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(e);
                out.close();
                byte[] serializedException = byteStream.toByteArray();
                response.setJavaExceptionAsBytes(serializedException);
                if (!(e instanceof ApiProxy.ApplicationException)) break block3;
                ApiProxy.ApplicationException ae = (ApiProxy.ApplicationException)e;
                RemoteApiPb.ApplicationError appError = response.getMutableApplicationError();
                appError.setCode(ae.getApplicationError());
                appError.setDetail(ae.getErrorDetail());
            }
        }
        res.getOutputStream().write(response.toByteArray());
    }

    private byte[] executeRunQuery(RemoteApiPb.Request request) {
        DatastorePb.Query queryRequest = new DatastorePb.Query();
        queryRequest.parseFrom(request.getRequestAsBytes());
        int batchSize = Math.max(1000, queryRequest.getLimit());
        queryRequest.setCount(batchSize);
        DatastorePb.QueryResult runQueryResponse = new DatastorePb.QueryResult();
        byte[] res = ApiProxy.makeSyncCall("datastore_v3", "RunQuery", request.getRequestAsBytes());
        runQueryResponse.parseFrom(res);
        if (queryRequest.hasLimit()) {
            while (runQueryResponse.isMoreResults()) {
                DatastorePb.NextRequest nextRequest = new DatastorePb.NextRequest();
                nextRequest.getMutableCursor().mergeFrom(runQueryResponse.getCursor());
                nextRequest.setCount(batchSize);
                byte[] nextRes = ApiProxy.makeSyncCall("datastore_v3", "Next", nextRequest.toByteArray());
                runQueryResponse.mergeFrom(nextRes);
            }
        }
        return runQueryResponse.toByteArray();
    }

    private byte[] executeTxQuery(RemoteApiPb.Request request) {
        RemoteApiPb.TransactionQueryResult result = new RemoteApiPb.TransactionQueryResult();
        DatastorePb.Query query = new DatastorePb.Query();
        query.parseFrom(request.getRequestAsBytes());
        if (!query.hasAncestor()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "No ancestor in transactional query.");
        }
        OnestoreEntity.Reference egKey = result.getMutableEntityGroupKey().mergeFrom(query.getAncestor());
        OnestoreEntity.Path.Element root = egKey.getPath().getElement(0);
        egKey.getMutablePath().clearElement().addElement(root);
        OnestoreEntity.Path.Element egElement = new OnestoreEntity.Path.Element();
        egElement.setType("__entity_group__").setId(1L);
        egKey.getMutablePath().addElement(egElement);
        byte[] tx = RemoteApiServlet.beginTransaction(false);
        query.getMutableTransaction().parseFrom(tx);
        byte[] queryBytes = ApiProxy.makeSyncCall("datastore_v3", "RunQuery", query.toByteArray());
        result.getMutableResult().mergeFrom(queryBytes);
        DatastorePb.GetRequest egRequest = new DatastorePb.GetRequest();
        egRequest.addKey(egKey);
        DatastorePb.GetResponse egResponse = RemoteApiServlet.txGet(tx, egRequest);
        if (egResponse.getEntity(0).hasEntity()) {
            result.setEntityGroup(egResponse.getEntity(0).getEntity());
        }
        RemoteApiServlet.rollback(tx);
        return result.toByteArray();
    }

    private void assertEntityResultMatchesPrecondition(DatastorePb.GetResponse.Entity entityResult, RemoteApiPb.TransactionRequest.Precondition precondition) {
        if (precondition.hasHash() != entityResult.hasEntity()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition failed");
        }
        if (entityResult.hasEntity()) {
            OnestoreEntity.EntityProto entity = entityResult.getEntity();
            if (Arrays.equals(precondition.getHashAsBytes(), RemoteApiServlet.computeSha1(entity))) {
                return;
            }
            byte[] backwardsCompatibleHash = RemoteApiServlet.computeSha1OmittingLastByteForBackwardsCompatibility(entity);
            if (!Arrays.equals(precondition.getHashAsBytes(), backwardsCompatibleHash)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition failed");
            }
        }
    }

    private byte[] executeTx(RemoteApiPb.Request request) {
        RemoteApiPb.TransactionRequest txRequest = new RemoteApiPb.TransactionRequest();
        txRequest.parseFrom(request.getRequestAsBytes());
        byte[] tx = RemoteApiServlet.beginTransaction(txRequest.isAllowMultipleEg());
        List<RemoteApiPb.TransactionRequest.Precondition> preconditions = txRequest.preconditions();
        if (!preconditions.isEmpty()) {
            DatastorePb.GetRequest getRequest = new DatastorePb.GetRequest();
            for (RemoteApiPb.TransactionRequest.Precondition precondition : preconditions) {
                OnestoreEntity.Reference key = precondition.getKey();
                OnestoreEntity.Reference requestKey = getRequest.addKey();
                requestKey.mergeFrom(key);
            }
            DatastorePb.GetResponse getResponse = RemoteApiServlet.txGet(tx, getRequest);
            List<DatastorePb.GetResponse.Entity> entities = getResponse.entitys();
            assert (entities.size() == preconditions.size());
            for (int i = 0; i < entities.size(); ++i) {
                this.assertEntityResultMatchesPrecondition(entities.get(i), preconditions.get(i));
            }
        }
        byte[] res = new ApiBasePb.VoidProto().toByteArray();
        if (txRequest.hasPuts()) {
            DatastorePb.PutRequest putRequest = txRequest.getPuts();
            putRequest.getMutableTransaction().parseFrom(tx);
            res = ApiProxy.makeSyncCall("datastore_v3", "Put", putRequest.toByteArray());
        }
        if (txRequest.hasDeletes()) {
            DatastorePb.DeleteRequest deleteRequest = txRequest.getDeletes();
            deleteRequest.getMutableTransaction().parseFrom(tx);
            ApiProxy.makeSyncCall("datastore_v3", "Delete", deleteRequest.toByteArray());
        }
        ApiProxy.makeSyncCall("datastore_v3", "Commit", tx);
        return res;
    }

    private byte[] executeGetIDs(RemoteApiPb.Request request, boolean isXG) {
        DatastorePb.PutRequest putRequest = new DatastorePb.PutRequest();
        putRequest.parseFrom(request.getRequestAsBytes());
        for (OnestoreEntity.EntityProto entity : putRequest.entitys()) {
            assert (entity.propertySize() == 0);
            assert (entity.rawPropertySize() == 0);
            assert (entity.getEntityGroup().elementSize() == 0);
            List<OnestoreEntity.Path.Element> elementList = entity.getKey().getPath().elements();
            OnestoreEntity.Path.Element lastPart = elementList.get(elementList.size() - 1);
            assert (lastPart.getId() == 0L);
            assert (!lastPart.hasName());
        }
        byte[] tx = RemoteApiServlet.beginTransaction(isXG);
        putRequest.getMutableTransaction().mergeFrom(tx);
        byte[] res = ApiProxy.makeSyncCall("datastore_v3", "Put", putRequest.toByteArray());
        RemoteApiServlet.rollback(tx);
        return res;
    }

    private byte[] executeRequest(HttpServletRequest req) throws IOException {
        RemoteApiPb.Request request = new RemoteApiPb.Request();
        request.parseFrom((InputStream)req.getInputStream());
        String service = request.getServiceName();
        String method = request.getMethod();
        String string = String.valueOf(String.valueOf(service));
        String string2 = String.valueOf(String.valueOf(method));
        log.fine(new StringBuilder(19 + string.length() + string2.length()).append("remote API call: ").append(string).append(", ").append(string2).toString());
        if (service.equals("remote_datastore")) {
            if (method.equals("RunQuery")) {
                return this.executeRunQuery(request);
            }
            if (method.equals("Transaction")) {
                return this.executeTx(request);
            }
            if (method.equals("TransactionQuery")) {
                return this.executeTxQuery(request);
            }
            if (method.equals("GetIDs")) {
                return this.executeGetIDs(request, false);
            }
            if (method.equals("GetIDsXG")) {
                return this.executeGetIDs(request, true);
            }
            throw new ApiProxy.CallNotFoundException(service, method);
        }
        return ApiProxy.makeSyncCall(service, method, request.getRequestAsBytes());
    }

    private static byte[] beginTransaction(boolean allowMultipleEg) {
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        byte[] req = new DatastorePb.BeginTransactionRequest().setApp(appId).setAllowMultipleEg(allowMultipleEg).toByteArray();
        return ApiProxy.makeSyncCall("datastore_v3", "BeginTransaction", req);
    }

    private static void rollback(byte[] tx) {
        ApiProxy.makeSyncCall("datastore_v3", "Rollback", tx);
    }

    private static DatastorePb.GetResponse txGet(byte[] tx, DatastorePb.GetRequest request) {
        request.getMutableTransaction().parseFrom(tx);
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        byte[] resultBytes = ApiProxy.makeSyncCall("datastore_v3", "Get", request.toByteArray());
        response.parseFrom(resultBytes);
        return response;
    }

    static byte[] computeSha1(OnestoreEntity.EntityProto entity) {
        byte[] entityBytes = entity.toByteArray();
        return RemoteApiServlet.computeSha1(entityBytes, entityBytes.length);
    }

    static byte[] computeSha1OmittingLastByteForBackwardsCompatibility(OnestoreEntity.EntityProto entity) {
        byte[] entityBytes = entity.toByteArray();
        return RemoteApiServlet.computeSha1(entityBytes, entityBytes.length - 1);
    }

    private static byte[] computeSha1(byte[] bytes, int length) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition could not be computed");
        }
        md.update(bytes, 0, length);
        return md.digest();
    }

    public static class UnknownPythonServerException
    extends RuntimeException {
        public UnknownPythonServerException(String message) {
            super(message);
        }
    }
}

