/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.serviceapp;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;
import com.google.apphosting.client.serviceapp.AuthService;

public final class AuthServiceImpl
implements AuthService {
    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PACKAGE_PRIVATE)
    public static final String GET_OAUTH_USER_RESPONSE_KEY = "com.google.appengine.api.oauth.OAuthService.get_oauth_user_response";
    static final String REQUEST_WRITER_PERMISSION_KEY = "com.google.appengine.api.oauth.OAuthService.request_writer_permission";
    private OAuthService oauthService;

    public AuthServiceImpl(OAuthService oauthService) {
        this.oauthService = oauthService;
    }

    @Override
    public AuthService.UserPermissions getUserPermissions(String[] scopes, boolean requestWriterPermission) throws OAuthRequestException {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        environment.getAttributes().put(REQUEST_WRITER_PERMISSION_KEY, requestWriterPermission);
        boolean isAdmin = this.oauthService.isUserAdmin(scopes);
        UserServicePb.GetOAuthUserResponse response = (UserServicePb.GetOAuthUserResponse)environment.getAttributes().get(GET_OAUTH_USER_RESPONSE_KEY);
        boolean isWriter = response.hasIsProjectWriter() ? response.isIsProjectWriter() : isAdmin;
        return new AuthService.UserPermissions(new User(response.getEmail(), response.getAuthDomain(), response.getUserId()), isAdmin, isWriter, response.getClientId());
    }
}

