/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protos.gdata.proto2api.Core;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileClient;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileRpcHandler;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileValidator;
import com.google.apphosting.client.datastoreservice.app.mobile.MobileEntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.mobile.MobileV4NormAuthenticator;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;

public class SyncHandler
extends DatastoreMobileRpcHandler<DatastoreMobileService.SyncRequest, DatastoreMobileService.SyncResponse> {
    private final MobileEntityV4Normalizer entityNormalizer;
    private final MobileV4NormAuthenticator normAuthenticator;
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;
    private final DatastoreMobileValidator validator;

    protected SyncHandler(DatastoreMobileClient mobileClient, MobileEntityV4Normalizer entityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreMobileValidator validator, EntityTranslator.Format inputFormat) {
        super(mobileClient);
        this.entityNormalizer = entityNormalizer;
        this.resultTransform = resultTransform;
        this.normAuthenticator = new MobileV4NormAuthenticator(entityNormalizer, inputFormat);
        this.validator = validator;
    }

    @Override
    public Parser<DatastoreMobileService.SyncRequest> getParser() {
        return DatastoreMobileService.SyncRequest.PARSER;
    }

    @Override
    public Class<DatastoreMobileService.SyncRequest> getRequestClass() {
        return DatastoreMobileService.SyncRequest.class;
    }

    @Override
    public DatastoreMobileService.SyncResponse call(RpcHandler.CallOptions callOptions, DatastoreMobileService.SyncRequest req) throws RpcException {
        DatastoreMobileService.SyncResponse.Builder response = DatastoreMobileService.SyncResponse.newBuilder();
        DatastoreMobileService.CommitResponse commitResponse = null;
        if (req.hasCommitRequest()) {
            DatastoreMobileService.CommitRequest normalizedRequest = this.normAuthenticator.normalizeAndAuthenticateCommitRequest(req.getCommitRequest());
            commitResponse = ((DatastoreMobileClient)this.datastoreClient).commit(callOptions, this.resultTransform, normalizedRequest);
            response.setCommitResponse(commitResponse);
        }
        if (req.hasSinceQueryRequest()) {
            this.validator.validateSinceQuery(req.getMinVersion(), req.getSinceQueryRequest());
            DatastoreV4.RunQueryRequest normV4SinceQuery = this.normAuthenticator.normalizeAndAuthenticateRunQueryRequest(req.getSinceQueryRequest());
            int availableMaxBytes = callOptions.getMaxResponseBytes() - (commitResponse == null ? 0 : commitResponse.getSerializedSize());
            RpcHandler.CallOptions queryCallOptions = new RpcHandler.CallOptions(availableMaxBytes);
            DatastoreMobileClient.QueryResponseKey resonpseKey = ((DatastoreMobileClient)this.datastoreClient).retrieveModifiedServerEntities(queryCallOptions, this.resultTransform, normV4SinceQuery, req.getMinVersion(), this.entityNormalizer.getFullUserId(), commitResponse);
            if (resonpseKey.getQueryResponse() != null) {
                response.setSinceQueryResponse(resonpseKey.getQueryResponse());
            }
            if (resonpseKey.getLastKey() != null) {
                response.setLastEntityKey(resonpseKey.getLastKey());
            }
        }
        return response.build();
    }

    @Override
    public DatastoreMobileService.SyncResponse makeError(Codes.Code errorCode, String message) {
        Core.ErrorProto.Builder error = Core.ErrorProto.newBuilder().setDomain("util.error.Code").setExternalErrorMessage(message).setCode(errorCode.toString());
        return DatastoreMobileService.SyncResponse.newBuilder().setHeader(DatastoreMobileService.ResponseHeader.newBuilder().setErrors(Core.Errors.newBuilder().addError(error))).build();
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(DatastoreMobileService.SyncRequest request) {
        if (!request.getCommitRequest().getMutationList().isEmpty()) {
            return RpcHandler.RequestPermissions.READ_WRITE;
        }
        return RpcHandler.RequestPermissions.READ;
    }

    @Override
    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public DatastoreMobileService.SyncRequest deserializeWithHeader(byte[] body, DatastoreMobileService.RequestHeader hdr) throws InvalidProtocolBufferException {
        return this.getParser().parseFrom(body).toBuilder().setHeader(hdr).build();
    }

    @Override
    public MessageLite getRequestHeader(DatastoreMobileService.SyncRequest request) {
        return request.getHeader();
    }
}

