/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.apphosting.client.datastoreservice.app.DatastoreClient;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileClient;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileValidator;
import com.google.apphosting.client.datastoreservice.app.mobile.MobileEntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.mobile.RunQueryHandler;
import com.google.apphosting.client.datastoreservice.app.mobile.SyncHandler;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.RpcService;
import com.google.apphosting.client.serviceapp.ServiceRegistry;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;

@VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PACKAGE_PRIVATE)
public class DatastoreMobileRpcService
implements RpcService {
    private final DatastoreMobileClient mobileClient;
    private final MobileEntityV4Normalizer entityNormalizer;

    private Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> newResultTransformWithVersion(final EntityTranslator.Format format) {
        return new Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult>(){

            @Override
            public DatastoreV4.EntityResult apply(DatastoreV4.EntityResult input) {
                EntityV4.Entity entity = format.convert(input.getEntity());
                DatastoreV4.EntityResult.Builder result = DatastoreV4.EntityResult.newBuilder().setEntity(entity);
                if (input.hasVersion()) {
                    result.setVersion(input.getVersion()).build();
                }
                return result.build();
            }
        };
    }

    public DatastoreMobileRpcService(String datasetId, AuthService authService) {
        this(datasetId, new InternDatastoreRpcService(), authService);
    }

    @VisibleForTesting
    public DatastoreMobileRpcService(String datasetId, InternDatastoreRpcService internDatastoreRpcService, AuthService authService) {
        this.mobileClient = new DatastoreMobileClient(new DatastoreClient(internDatastoreRpcService), this.newResultTransformWithVersion(DatastoreClient.INTERNAL_FORMAT), DatastoreMobileValidator.DEFAULT);
        this.entityNormalizer = new MobileEntityV4Normalizer(EntityTranslator.DEFAULT, DatastoreClient.INTERNAL_FORMAT, datasetId, authService);
    }

    @Override
    public void registerService(ServiceRegistry registry) {
        SyncHandler syncHandler = this.newSyncHandler(EntityTranslator.Format.V1BETA3);
        registry.registerHandler("datastoremobile", "v1beta1", "sync", syncHandler);
        RunQueryHandler runQueryHandler = this.newRunQueryHandler(EntityTranslator.Format.V1BETA3);
        registry.registerHandler("datastoremobile", "v1beta1", "runQuery", runQueryHandler);
    }

    @VisibleForTesting
    SyncHandler newSyncHandler(EntityTranslator.Format format) {
        return new SyncHandler(this.mobileClient, this.entityNormalizer, this.newResultTransformWithVersion(format), DatastoreMobileValidator.DEFAULT, format);
    }

    @VisibleForTesting
    RunQueryHandler newRunQueryHandler(EntityTranslator.Format format) {
        return new RunQueryHandler(this.mobileClient, this.entityNormalizer, this.newResultTransformWithVersion(format), DatastoreMobileValidator.DEFAULT, format);
    }
}

