/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileRpcHandler;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileRpcService;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.AuthServiceImpl;
import com.google.apphosting.client.serviceapp.BaseApiServlet;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import java.io.IOException;
import javax.annotation.Nullable;

public class DatastoreMobileApiServlet
extends BaseApiServlet {
    @VisibleForTesting
    static final String API_HEADER = "X-AppEngine-DatastoreMobile-API";
    @VisibleForTesting
    public static final String[] OAUTH2_SCOPE_STRINGS = new String[]{"https://www.googleapis.com/auth/datastoremobile", "https://www.googleapis.com/auth/cloud-platform"};
    @VisibleForTesting
    public static final String[] OAUTH2_SCOPE_CODES = new String[]{"43610", "35600"};
    public static final String INVALID_CLIENT_ID_ERROR = "Invalid Client ID.";
    public static final String INVALID_USER_CRED_ERROR = "Unauthorized.";

    public DatastoreMobileApiServlet() {
        this(new AuthServiceImpl(OAuthServiceFactory.getOAuthService()));
    }

    @VisibleForTesting
    public DatastoreMobileApiServlet(AuthService authService) {
        this(new DatastoreMobileRpcService(ApiProxy.getCurrentEnvironment().getAppId(), authService), authService);
    }

    DatastoreMobileApiServlet(DatastoreMobileRpcService rpcService, AuthService authService) {
        super(rpcService, authService);
    }

    @Override
    protected String getApiHeader() {
        return API_HEADER;
    }

    @Override
    protected String[] getOAuthScopeStrings() {
        return OAUTH2_SCOPE_STRINGS;
    }

    @Override
    protected String[] getOAuthScopeCodes() {
        return OAUTH2_SCOPE_CODES;
    }

    @Override
    protected void authenticate(RpcHandler.RequestPermissions requiredPermissions, @Nullable MessageLite requestHeader) throws RpcException {
        String errMsg;
        try {
            this.authService.getUserPermissions(OAUTH2_SCOPE_CODES, false);
            String clientTokenAppId = this.getClientTokenProjectId(requestHeader);
            String appId = ApiProxy.getCurrentEnvironment().getAppId();
            if (appId.equals(clientTokenAppId)) {
                return;
            }
            String string = String.valueOf(String.valueOf("Invalid Client ID.: expected="));
            String string2 = String.valueOf(String.valueOf(appId));
            String string3 = String.valueOf(String.valueOf(clientTokenAppId));
            errMsg = new StringBuilder(6 + string.length() + string2.length() + string3.length()).append(string).append(string2).append(", got=").append(string3).toString();
        }
        catch (OAuthRequestException ex) {
            String string = String.valueOf("Unauthorized.: ");
            String string4 = String.valueOf(ex.getMessage());
            errMsg = string4.length() != 0 ? string.concat(string4) : new String(string);
        }
        throw new RpcException(Codes.Code.PERMISSION_DENIED, errMsg);
    }

    private String getClientTokenProjectId(MessageLite requestHeader) {
        return requestHeader == null ? "" : ((DatastoreMobileService.RequestHeader)requestHeader).getClientTokenProjectId();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public byte[] injectRequestHeaderForTest(String uri, byte[] body, DatastoreMobileService.RequestHeader hdr) throws IOException {
        DatastoreMobileRpcHandler handler = (DatastoreMobileRpcHandler)this.getHandler(uri);
        return handler.deserializeWithHeader(body, hdr).toByteArray();
    }
}

