/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.io.base.Marshaller;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.bridge.BaseMessageMarshaller;
import java.io.IOException;
import java.io.Serializable;

public class MessageMarshaller<T extends Message>
extends BaseMessageMarshaller<T>
implements Serializable {
    private static final long serialVersionUID = 233811181L;
    private final transient T defaultInstance;
    private final Class<? extends Message> messageClass;

    public MessageMarshaller(T defaultInstance) {
        this.messageClass = defaultInstance.getClass();
        this.defaultInstance = defaultInstance;
    }

    @Override
    protected T reconstituteMessage(CodedInputStream codedInputStream) throws IOException {
        return (T)this.defaultInstance.getParserForType().parsePartialFrom(codedInputStream);
    }

    public static <T extends Message> Marshaller<T> of(Class<T> messageClass) {
        return new MessageMarshaller<T>(MessageMarshaller.getDefaultInstanceOf(messageClass));
    }

    private Object readResolve() {
        return MessageMarshaller.of(this.messageClass);
    }
}

