/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.DynamicMessage;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.bridge.DowngradedMessage;
import com.google.appengine.repackaged.com.google.protobuf.bridge.StubbyRpcController;
import com.google.appengine.repackaged.com.google.protobuf.bridge.StubbyRpcServerConfig;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStreamingListener;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.ssl.SslSecurityLevel;
import java.util.Iterator;
import java.util.List;

abstract class AbstractStubbyService
extends RpcService {
    private final String serviceName;
    private final ExtensionRegistry extensionRegistry;
    private static final RpcCancelCallback CANCEL_CALLBACK_HANDLER = null;

    AbstractStubbyService(String serviceName, ExtensionRegistry registry) {
        this.serviceName = serviceName;
        this.extensionRegistry = Preconditions.checkNotNull(registry);
    }

    public final RpcServerConfig export(RpcHandlerRegistry handlerRegistry) {
        StubbyRpcServerConfig config = new StubbyRpcServerConfig(this.serviceName);
        Descriptors.ServiceDescriptor serviceDescriptor = this.getDescriptorForType();
        List<Descriptors.MethodDescriptor> methods = serviceDescriptor.getMethods();
        for (Descriptors.MethodDescriptor methodDescriptor : methods) {
            DescriptorProtos.MethodOptions methodOptions = methodDescriptor.getOptions();
            RpcServerParameters serverParameters = new RpcServerParameters();
            serverParameters.setRpcCancelCallback(CANCEL_CALLBACK_HANDLER);
            if (methodOptions.hasSecurityLevel()) {
                serverParameters.setSecurityLevel(SslSecurityLevel.valueOf((String)methodOptions.getSecurityLevel().toString()));
            }
            if (methodOptions.hasSecurityLabel()) {
                serverParameters.setSecurityLabel(methodOptions.getSecurityLabel());
            }
            if (methodOptions.hasServerLogging()) {
                serverParameters.setServerLogging(methodOptions.getServerLogging());
            }
            Message requestPrototype = this.getRequestPrototype(methodDescriptor);
            Message responsePrototype = this.getResponsePrototype(methodDescriptor);
            handlerRegistry.registerHandler(this.serviceName, methodDescriptor.getName(), (ProtocolMessage)new DowngradedMessage(requestPrototype, this.extensionRegistry), (ProtocolMessage)new DowngradedMessage(responsePrototype, this.extensionRegistry), (ProtocolMessage)(methodOptions.hasStreamType() ? new DowngradedMessage(AbstractStubbyService.getStreamPrototype(methodDescriptor), this.extensionRegistry) : null), serverParameters, this.newApplicationHandler(methodDescriptor, this.extensionRegistry));
            config.addMethodParameters(methodDescriptor, serverParameters);
        }
        return config;
    }

    private static Message getStreamPrototype(Descriptors.MethodDescriptor method) {
        Message result;
        block1: {
            Descriptors.FileDescriptor subfile;
            Descriptors.FileDescriptor file;
            String streamType = method.getOptions().getStreamType();
            result = AbstractStubbyService.findStreamTypeInFile(streamType, file = method.getService().getFile());
            if (result != null) break block1;
            Iterator<Descriptors.FileDescriptor> iterator = file.getDependencies().iterator();
            while (iterator.hasNext() && (result = AbstractStubbyService.findStreamTypeInFile(streamType, subfile = iterator.next())) == null) {
            }
        }
        return result;
    }

    private static Message findStreamTypeInFile(String streamType, Descriptors.FileDescriptor file) {
        String suffix;
        Descriptors.Descriptor descriptor;
        String filePackagePrefix = String.valueOf(file.getPackage()).concat(".");
        if (streamType.startsWith(filePackagePrefix) && (descriptor = file.findMessageTypeByName(suffix = streamType.substring(filePackagePrefix.length()))) != null) {
            return DynamicMessage.getDefaultInstance(descriptor);
        }
        return null;
    }

    abstract Message getResponsePrototype(Descriptors.MethodDescriptor var1);

    abstract Message getRequestPrototype(Descriptors.MethodDescriptor var1);

    abstract Descriptors.ServiceDescriptor getDescriptorForType();

    abstract ApplicationHandler newApplicationHandler(Descriptors.MethodDescriptor var1, ExtensionRegistry var2);

    static abstract class AbstractStubbyApplicationHandler
    implements ApplicationHandler {
        private final ExtensionRegistry extensionRegistry;

        AbstractStubbyApplicationHandler(ExtensionRegistry registry) {
            this.extensionRegistry = registry;
        }

        public final void handleRequest(RPC rpc) {
            StubbyRpcController controller = this.createController(rpc);
            this.internalHandleRequest(rpc, controller);
        }

        private StubbyRpcController createController(final RPC rpc) {
            return new StubbyRpcController(rpc){

                @Override
                public void streamReady(Message message) {
                    String streamType = AbstractStubbyApplicationHandler.this.getStreamType();
                    RpcCallback internalCallback = rpc.internalCallback();
                    RpcStreamingListener<DowngradedMessage> callback = this.castCallback(internalCallback);
                    if (streamType == null) {
                        throw new UnsupportedOperationException("Method does not support streaming");
                    }
                    if (!message.getDescriptorForType().getFullName().equals(streamType)) {
                        throw new IllegalArgumentException("Wrong streaming type");
                    }
                    callback.streamReady((ProtocolMessage)new DowngradedMessage(message, AbstractStubbyApplicationHandler.this.extensionRegistry));
                }

                private RpcStreamingListener<DowngradedMessage> castCallback(RpcCallback internalCallback) {
                    return (RpcStreamingListener)internalCallback;
                }
            };
        }

        abstract void internalHandleRequest(RPC var1, StubbyRpcController var2);

        abstract String getStreamType();
    }
}

