/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class FlagValues {
    private final Map<String, String> values;

    public FlagValues() {
        this.values = new LinkedHashMap<String, String>();
    }

    public FlagValues(FlagValues other) {
        this.values = new LinkedHashMap<String, String>(other.values);
    }

    public void addFlag(String flag, String value) {
        FlagDescription.checkNotNull(flag);
        FlagDescription.checkNotNull(value);
        this.values.put(flag, value);
    }

    @Nullable
    public String getFlagValue(String flag) {
        FlagDescription.checkNotNull(flag);
        return this.values.get(flag);
    }

    public String[] getAllFlagsAsStringArray() {
        String[] flags = new String[this.values.size()];
        int i = 0;
        for (String flagName : this.values.keySet()) {
            String string;
            String flagValue = this.values.get(flagName);
            String string2 = String.valueOf(String.valueOf(flagName));
            if ("".equals(flagValue)) {
                string = "";
            } else {
                String string3 = String.valueOf(flagValue);
                string = string3.length() != 0 ? "=".concat(string3) : new String("=");
            }
            String string4 = String.valueOf(String.valueOf(string));
            flags[i] = new StringBuilder(2 + string2.length() + string4.length()).append("--").append(string2).append(string4).toString();
            ++i;
        }
        return flags;
    }
}

