/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Converter;

public final class FlagConverters {
    private static final Converter<String, Boolean> BOOLEAN_CONVERTER = new Converter<String, Boolean>(){

        @Override
        protected Boolean doForward(String input) {
            switch (Ascii.toLowerCase(input)) {
                case "1": 
                case "t": 
                case "y": 
                case "yes": 
                case "true": {
                    return true;
                }
                case "0": 
                case "f": 
                case "n": 
                case "no": 
                case "false": {
                    return false;
                }
            }
            String string = String.valueOf(String.valueOf(input));
            throw new IllegalArgumentException(new StringBuilder(22 + string.length()).append("'").append(string).append("' is an invalid input").toString());
        }

        @Override
        protected String doBackward(Boolean input) {
            return input.toString();
        }
    };

    public static Converter<String, Boolean> toBoolean() {
        return BOOLEAN_CONVERTER;
    }

    private FlagConverters() {
    }
}

