/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.appengine.api.taskqueue.QueueApiHelper;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class TaskHandle
implements Serializable {
    private static final long serialVersionUID = -2578988193753847512L;
    private String taskName;
    private String queueName;
    private long etaUsec;
    private long etaMillis;
    private Integer retryCount;
    private TaskOptions options;

    TaskHandle(TaskOptions options, String queueName, Integer retryCount) {
        TaskHandle.validateTaskName(options.getTaskName());
        QueueApiHelper.validateQueueName(queueName);
        this.queueName = queueName;
        this.retryCount = retryCount;
        this.taskName = null;
        this.etaMillis = 0L;
        this.options = new TaskOptions(options);
        this.setEtaUsecFromOptions(this.options);
    }

    public TaskHandle(TaskOptions options, String queueName) {
        this(options, queueName, (Integer)0);
    }

    @Deprecated
    public TaskHandle(String name, String queueName, long etaMillis) {
        this(TaskOptions.Builder.withTaskName(name).etaMillis(etaMillis), queueName, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.options == null) {
            this.options = TaskOptions.Builder.withTaskName(this.taskName).etaMillis(this.etaMillis);
            this.taskName = null;
            this.etaMillis = 0L;
        }
        if (this.etaUsec == 0L && this.options.getEtaMillis() != null) {
            this.setEtaUsecFromOptions(this.options);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = this.options.hashCode();
        result = result * 31 + this.queueName.hashCode();
        result = result * 31 + (this.retryCount == null ? 0 : this.retryCount);
        result = result * 31 + (int)(this.etaUsec ^ this.etaUsec >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskHandle other = (TaskHandle)obj;
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.retryCount == null ? other.retryCount != null : !this.retryCount.equals(other.retryCount)) {
            return false;
        }
        return this.etaUsec == other.etaUsec;
    }

    public String toString() {
        return "TaskHandle[options=" + this.options + "queueName=" + this.queueName + ", retryCount=" + this.retryCount + ", etaMillis = " + this.etaMillis + ", etaUsec = " + this.etaUsec + "]";
    }

    static void validateTaskName(String taskName) {
        if (taskName == null || taskName.length() == 0 || !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new IllegalArgumentException("Task name does not match expression " + QueueConstants.TASK_NAME_REGEX + "; given taskname: '" + taskName + "'");
        }
    }

    public String getName() {
        return this.options.getTaskName();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public long getEtaMillis() {
        return this.options.getEtaMillis();
    }

    void etaMillis(long etaMillis) {
        this.options.etaMillis(etaMillis);
        this.etaUsec = etaMillis * 1000L;
    }

    long getEtaUsec() {
        return this.etaUsec;
    }

    TaskHandle etaUsec(long etaUsec) {
        this.etaUsec = etaUsec;
        this.options.etaMillis(etaUsec / 1000L);
        return this;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public byte[] getPayload() {
        return this.options.getPayload();
    }

    public String getTag() throws UnsupportedEncodingException {
        return this.options.getTag();
    }

    public byte[] getTagAsBytes() {
        return this.options.getTagAsBytes();
    }

    private void setEtaUsecFromOptions(TaskOptions options) {
        this.etaUsec = options != null && options.getEtaMillis() != null ? options.getEtaMillis() * 1000L : 0L;
    }

    public List<Map.Entry<String, String>> extractParams() throws UnsupportedEncodingException, UnsupportedOperationException {
        String payload = new String(this.getPayload());
        String[] paramStrings = payload.split("&");
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (String param : paramStrings) {
            String[] kv = param.split("=", 2);
            if (kv.length != 2) {
                throw new UnsupportedOperationException("Payload " + payload + " failed to decode as application/x-www-form-urlencoded pairs. " + param + " Length" + kv.length);
            }
            result.add(new KeyValuePair(URLDecoder.decode(kv[0], "UTF-8"), URLDecoder.decode(kv[1], "UTF-8")));
        }
        return result;
    }

    static final class KeyValuePair
    implements Map.Entry<String, String> {
        private final String key;
        private String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String v) {
            String old = this.value;
            this.value = v;
            return old;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = prime * result + this.key.hashCode();
            result = prime * result + this.value.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyValuePair)) {
                return false;
            }
            KeyValuePair that = (KeyValuePair)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }
    }
}

