/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.GetOrCreateTransactionResult;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import java.util.concurrent.Future;

abstract class TransactionRunner<T> {
    private final Transaction txn;
    private final boolean finishTxn;

    protected TransactionRunner(GetOrCreateTransactionResult result) {
        this.txn = result.getTransaction();
        this.finishTxn = result.isNew();
        if (this.txn == null && this.finishTxn) {
            throw new IllegalArgumentException("Cannot have a null txn when finishTxn is true.  This almost certainly represents a programming error on the part of the App Engine team.  Please report this via standard support channels and accept our humblest apologies.");
        }
        TransactionImpl.ensureTxnActive(this.txn);
    }

    public Future<T> runReadInTransaction() {
        if (!this.finishTxn) {
            return this.runInternal(this.txn);
        }
        return new FutureWrapper<T, T>(this.runInternal(this.txn)){

            @Override
            protected T wrap(T result) throws Exception {
                TransactionRunner.this.txn.commit();
                return result;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                TransactionRunner.this.txn.rollback();
                return cause;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> runWriteInTransaction() {
        Future<Void> txnFuture;
        if (!this.finishTxn) {
            return this.runInternal(this.txn);
        }
        Object result = null;
        Exception capturedException = null;
        try {
            result = FutureHelper.quietGet(this.runInternal(this.txn));
        }
        catch (Exception e) {
            capturedException = e;
        }
        finally {
            txnFuture = capturedException == null ? this.txn.commitAsync() : this.txn.rollbackAsync();
        }
        final Object finalResult = result;
        final Exception finalCapturedException = capturedException;
        return new FutureWrapper<Void, T>(txnFuture){

            @Override
            protected T wrap(Void v) throws Exception {
                if (finalCapturedException != null) {
                    throw finalCapturedException;
                }
                return finalResult;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    protected abstract Future<T> runInternal(Transaction var1);
}

