/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DatastoreV4Proxy;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.WrappedQueryResultV4;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.concurrent.Future;

class QueryResultsSourceCloudDatastore
extends BaseQueryResultsSource<DatastoreV4.RunQueryResponse, DatastoreV4.RunQueryRequest, DatastoreV4.RunQueryResponse> {
    private final DatastoreV4Proxy dsApiProxy;
    private final DatastoreV4.RunQueryRequest initialRequest;
    private int remainingLimit;

    QueryResultsSourceCloudDatastore(DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, DatastoreV4.RunQueryRequest request, Future<DatastoreV4.RunQueryResponse> runQueryResponse, DatastoreV4Proxy dsApiProxy) {
        super(callbacks, fetchOptions, txn, query, runQueryResponse);
        this.initialRequest = request;
        this.dsApiProxy = dsApiProxy;
        this.remainingLimit = fetchOptions.getLimit() != null ? fetchOptions.getLimit() : -1;
    }

    @Override
    DatastoreV4.RunQueryRequest buildNextCallPrototype(DatastoreV4.RunQueryResponse initialResponse) {
        return this.initialRequest;
    }

    @Override
    Future<DatastoreV4.RunQueryResponse> makeNextCall(DatastoreV4.RunQueryRequest prototype, BaseQueryResultsSource.WrappedQueryResult latestResult, Integer fetchCount, Integer offset) {
        DatastoreV4.RunQueryRequest.Builder runQueryRequest = prototype.toBuilder();
        DatastoreV4.Query.Builder query = runQueryRequest.getQueryBuilder();
        DatastoreV4.QueryResultBatch latestBatch = ((WrappedQueryResultV4)latestResult).getBatch();
        if (!latestBatch.hasEndCursor()) {
            throw new IllegalArgumentException();
        }
        query.setStartCursor(latestBatch.getEndCursor());
        if (query.hasLimit()) {
            this.remainingLimit -= latestBatch.getEntityResultCount();
            query.setLimit(Math.max(this.remainingLimit, 0));
        }
        if (offset != null) {
            query.setOffset(offset);
        } else {
            query.clearOffset();
        }
        return this.dsApiProxy.runQuery(runQueryRequest.build());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapInitialResult(DatastoreV4.RunQueryResponse initialResponse) {
        return new WrappedQueryResultV4(initialResponse.getBatch());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapResult(DatastoreV4.RunQueryResponse res) {
        return new WrappedQueryResultV4(res.getBatch());
    }
}

