/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BasePreparedQuery;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.LazyList;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultIteratorImpl;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.QueryRunner;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;

class PreparedQueryImpl
extends BasePreparedQuery {
    private final Query query;
    private final Transaction txn;
    private final QueryRunner queryRunner;

    public PreparedQueryImpl(Query query, Transaction txn, QueryRunner queryRunner) {
        this.query = query;
        this.txn = txn;
        this.queryRunner = queryRunner;
        Preconditions.checkArgument(query.getFilter() == null);
        Preconditions.checkArgument(txn == null || query.getAncestor() != null, "Only ancestor queries are allowed inside transactions.");
        TransactionImpl.ensureTxnActive(txn);
    }

    private QueryResultIteratorImpl runQuery(FetchOptions fetchOptions) {
        return new QueryResultIteratorImpl(this, this.queryRunner.runQuery(fetchOptions, this.query, this.txn), fetchOptions, this.txn);
    }

    @Override
    public List<Entity> asList(FetchOptions fetchOptions) {
        return new LazyList(this.runQuery(fetchOptions));
    }

    @Override
    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        if (override.getCompile() == null) {
            override.compile(true);
        }
        LazyList lazyList = new LazyList(this.runQuery(override));
        return lazyList;
    }

    @Override
    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        return this.runQuery(fetchOptions);
    }

    @Override
    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        if (fetchOptions.getCompile() == null) {
            fetchOptions = new FetchOptions(fetchOptions).compile(true);
        }
        return this.runQuery(fetchOptions);
    }

    @Override
    public Entity asSingleEntity() throws PreparedQuery.TooManyResultsException {
        List<Entity> entities = this.asList(FetchOptions.Builder.withLimit(2));
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() != 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return entities.get(0);
    }

    @Override
    public int countEntities(FetchOptions fetchOptions) {
        FetchOptions overrideOptions = new FetchOptions(fetchOptions);
        overrideOptions.limit(0);
        if (fetchOptions.getLimit() != null) {
            if (fetchOptions.getOffset() != null) {
                int offset = fetchOptions.getLimit() + fetchOptions.getOffset();
                overrideOptions.offset(offset >= 0 ? offset : Integer.MAX_VALUE);
            } else {
                overrideOptions.offset(fetchOptions.getLimit());
            }
        } else {
            overrideOptions.offset(Integer.MAX_VALUE);
        }
        int count = this.runQuery(overrideOptions).getNumSkipped();
        if (fetchOptions.getOffset() != null) {
            count = count < fetchOptions.getOffset() ? 0 : (count -= fetchOptions.getOffset().intValue());
        }
        return count;
    }

    public String toString() {
        return this.query + (this.txn != null ? " IN " + this.txn : "");
    }
}

