/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.datastore.DatastoreApiHelper;

public final class DatastoreAttributes {
    private final DatastoreType datastoreType;
    private static final AppIdentityService appIdentityService = AppIdentityServiceFactory.getAppIdentityService();

    DatastoreAttributes() {
        this(DatastoreApiHelper.getCurrentAppId());
    }

    DatastoreAttributes(String appId) {
        AppIdentityService.ParsedAppId identity = appIdentityService.parseFullAppId(appId);
        this.datastoreType = identity.getPartition().isEmpty() ? DatastoreType.MASTER_SLAVE : DatastoreType.HIGH_REPLICATION;
    }

    public DatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    public static enum DatastoreType {
        UNKNOWN,
        MASTER_SLAVE,
        HIGH_REPLICATION;

    }
}

