/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityCache;
import com.google.appengine.api.datastore.EntityCachingStrategy;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.MemcacheServiceHelper;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.datastore.EntityStorage;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

final class CacheOnlyEntityCachingStrategy
extends EntityCachingStrategy {
    private final EntityCache cache;
    private final DatastoreServiceConfig datastoreServiceConfig;

    CacheOnlyEntityCachingStrategy(DatastoreServiceConfig datastoreServiceConfig) {
        MemcacheServiceHelper memcacheServiceHelper = MemcacheServiceHelper.Builder.withDefaults();
        double datastoreRpcDeadline = datastoreServiceConfig.getDeadline() == null ? 60.0 : datastoreServiceConfig.getDeadline();
        this.cache = new EntityCache(memcacheServiceHelper, datastoreRpcDeadline);
        this.datastoreServiceConfig = datastoreServiceConfig;
    }

    CacheOnlyEntityCachingStrategy(EntityCache cache, DatastoreServiceConfig datastoreServiceConfig) {
        this.cache = cache;
        this.datastoreServiceConfig = datastoreServiceConfig;
    }

    @Override
    public EntityCachingStrategy.PreGetCachingResult preGet(CurrentTransactionProvider currentTxnProvider, List<Key> keysToGet, Map<Key, Entity> resultMap) {
        List<Key> cacheableKeys = CacheOnlyEntityCachingStrategy.getCacheableKeys(this.datastoreServiceConfig, keysToGet);
        Future<Map<Object, Object>> cacheGetResults = cacheableKeys.isEmpty() ? new FutureHelper.FakeFuture(ImmutableMap.of()) : this.cache.getIdentifiableAsync(cacheableKeys);
        return new CacheOnlyPreGetCachingResult(Sets.newHashSet(cacheableKeys), cacheGetResults);
    }

    @Override
    protected void postGet(EntityCachingStrategy.PreGetCachingResult preGetResult, Map<Key, Entity> resultMap) {
        CacheOnlyPreGetCachingResult preGetStrategyResult = (CacheOnlyPreGetCachingResult)preGetResult;
        Map<Key, EntityCache.IdentifiableCacheValue> cacheResults = FutureHelper.quietGet(preGetStrategyResult.getCacheResults());
        for (Map.Entry<Key, EntityCache.IdentifiableCacheValue> cacheEntry : cacheResults.entrySet()) {
            EntityStorage.CacheValue cacheValue = cacheEntry.getValue().getValue();
            if (cacheValue.getStateEnum() != EntityStorage.CacheValue.State.ENTITY || !cacheValue.hasEntity()) continue;
            resultMap.put(cacheEntry.getKey(), EntityTranslator.createFromPb(cacheValue.getEntity().getV3Entity()));
        }
    }

    @Override
    public EntityCachingStrategy.PreMutationCachingResult prePut(CurrentTransactionProvider currentTxnProvider, List<Entity> entitiesToPut) {
        if (currentTxnProvider.getCurrentTransaction(null) == null) {
            return this.preCommit(entitiesToPut, ImmutableList.of());
        }
        EntityCachingStrategy.PreMutationCachingResult preMutationResult = new EntityCachingStrategy.PreMutationCachingResult(ImmutableSet.of());
        List<Entity> cacheableEntities = CacheOnlyEntityCachingStrategy.getCacheableEntities(this.datastoreServiceConfig, entitiesToPut);
        HashSet<Key> mutationKeysToSkip = Sets.newHashSetWithExpectedSize(cacheableEntities.size());
        for (Entity cacheableEntity : cacheableEntities) {
            mutationKeysToSkip.add(cacheableEntity.getKey());
        }
        preMutationResult.setMutationKeysToSkip(mutationKeysToSkip);
        return preMutationResult;
    }

    @Override
    public EntityCachingStrategy.PreMutationCachingResult preDelete(CurrentTransactionProvider currentTxnProvider, List<Key> keysToDelete) {
        if (currentTxnProvider.getCurrentTransaction(null) == null) {
            return this.preCommit(ImmutableList.of(), keysToDelete);
        }
        EntityCachingStrategy.PreMutationCachingResult preMutationResult = new EntityCachingStrategy.PreMutationCachingResult(ImmutableSet.of());
        List<Key> cacheableKeys = CacheOnlyEntityCachingStrategy.getCacheableKeys(this.datastoreServiceConfig, keysToDelete);
        preMutationResult.setMutationKeysToSkip(Sets.newHashSet(cacheableKeys));
        return preMutationResult;
    }

    @Override
    public EntityCachingStrategy.PreMutationCachingResult preCommit(List<Entity> entitiesToPut, List<Key> keysToDelete) {
        List<Entity> cacheableEntitiesToPut = CacheOnlyEntityCachingStrategy.getCacheableEntities(this.datastoreServiceConfig, entitiesToPut);
        List<Key> cacheableKeysToDelete = CacheOnlyEntityCachingStrategy.getCacheableKeys(this.datastoreServiceConfig, keysToDelete);
        Future<Set<Key>> keysPut = new FutureHelper.FakeFuture<Set<Key>>(ImmutableSet.of());
        FutureHelper.FakeFuture<Set<Key>> keysEvicted = new FutureHelper.FakeFuture(ImmutableSet.of());
        if (!cacheableEntitiesToPut.isEmpty()) {
            HashSet<Key> cacheableKeysToDeleteSet = Sets.newHashSet(cacheableKeysToDelete);
            HashMap<Key, OnestoreEntity.EntityProto> entityMap = Maps.newHashMapWithExpectedSize(cacheableEntitiesToPut.size());
            for (Entity entity : cacheableEntitiesToPut) {
                Key entityKey = entity.getKey();
                if (!entityKey.isComplete() || cacheableKeysToDeleteSet.contains(entityKey)) continue;
                entityMap.put(entityKey, EntityTranslator.convertToPb(entity));
            }
            if (!entityMap.isEmpty()) {
                keysPut = this.cache.putEntitiesAsync(entityMap, MemcacheService.SetPolicy.SET_ALWAYS);
            }
        }
        if (!cacheableKeysToDelete.isEmpty()) {
            keysEvicted = this.cache.evictAsync(cacheableKeysToDelete);
        }
        HashSet<Key> mutationKeysToSkip = Sets.newHashSetWithExpectedSize(cacheableEntitiesToPut.size());
        for (Entity cacheableEntity : cacheableEntitiesToPut) {
            mutationKeysToSkip.add(cacheableEntity.getKey());
        }
        mutationKeysToSkip.addAll(cacheableKeysToDelete);
        return new CacheOnlyPreMutationCachingResult(mutationKeysToSkip, keysPut, keysEvicted);
    }

    @Override
    protected void postMutation(EntityCachingStrategy.PreMutationCachingResult preMutationResult) {
        CacheOnlyPreMutationCachingResult preMutationStrategyResult = (CacheOnlyPreMutationCachingResult)preMutationResult;
        FutureHelper.quietGet(preMutationStrategyResult.getKeysPut());
        FutureHelper.quietGet(preMutationStrategyResult.getKeysEvicted());
    }

    static final class CacheOnlyPreMutationCachingResult
    extends EntityCachingStrategy.PreMutationCachingResult {
        private final Future<Set<Key>> keysPut;
        private final Future<Set<Key>> keysEvicted;

        public CacheOnlyPreMutationCachingResult(Set<Key> mutationKeysToSkip, Future<Set<Key>> keysPut, Future<Set<Key>> keysEvicted) {
            super(mutationKeysToSkip);
            this.keysPut = keysPut;
            this.keysEvicted = keysEvicted;
        }

        public Future<Set<Key>> getKeysPut() {
            return this.keysPut;
        }

        public Future<Set<Key>> getKeysEvicted() {
            return this.keysEvicted;
        }
    }

    static final class CacheOnlyPreGetCachingResult
    extends EntityCachingStrategy.PreGetCachingResult {
        private final Future<Map<Key, EntityCache.IdentifiableCacheValue>> cacheResults;

        public CacheOnlyPreGetCachingResult(Set<Key> keysToSkipLoading, Future<Map<Key, EntityCache.IdentifiableCacheValue>> cacheResults) {
            super(keysToSkipLoading);
            this.cacheResults = cacheResults;
        }

        public Future<Map<Key, EntityCache.IdentifiableCacheValue>> getCacheResults() {
            return this.cacheResults;
        }
    }
}

