/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitter;
import java.util.Collections;
import java.util.Comparator;

abstract class BaseQuerySplitter
implements QuerySplitter {
    protected static final Comparator<ComparableValue> VALUE_COMPARATOR_ASC = new Comparator<ComparableValue>(){

        @Override
        public int compare(ComparableValue o1, ComparableValue o2) {
            return EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(o1.comparableValue, o2.comparableValue);
        }
    };
    protected static final Comparator<ComparableValue> VALUE_COMPARATOR_DESC = Collections.reverseOrder(VALUE_COMPARATOR_ASC);

    protected BaseQuerySplitter() {
    }

    protected static Comparator<ComparableValue> getValueComparator(Query.SortDirection sortDirection) {
        if (sortDirection == Query.SortDirection.DESCENDING) {
            return VALUE_COMPARATOR_DESC;
        }
        return VALUE_COMPARATOR_ASC;
    }

    protected static class ComparableValue {
        private final Comparable<Object> comparableValue;
        private final Object originalValue;

        public ComparableValue(Object value) {
            this.comparableValue = DataTypeTranslator.getComparablePropertyValue(value);
            this.originalValue = value;
        }

        public Object getValue() {
            return this.originalValue;
        }
    }
}

