/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mps.MPSDemuxer;
import org.jcodec.containers.mps.MPSUtils;
import org.jcodec.containers.mps.index.BaseIndexer;
import org.jcodec.containers.mps.index.MPSIndex;

public class MPSIndexer
extends BaseIndexer {
    private long predFileStart;

    public void index(File source, NIOUtils.FileReaderListener listener) throws IOException {
        this.newReader().readFile(source, 65536, listener);
    }

    public void index(SeekableByteChannel source, NIOUtils.FileReaderListener listener) throws IOException {
        this.newReader().readFile(source, 65536, listener);
    }

    private NIOUtils.FileReader newReader() {
        return new NIOUtils.FileReader(){

            @Override
            protected void data(ByteBuffer data, long filePos) {
                MPSIndexer.this.analyseBuffer(data, filePos);
            }

            @Override
            protected void done() {
                MPSIndexer.this.finishAnalyse();
            }
        };
    }

    @Override
    protected void pes(ByteBuffer pesBuffer, long start, int pesLen, int stream) {
        if (!MPSUtils.mediaStream(stream)) {
            return;
        }
        MPSDemuxer.PESPacket pesHeader = MPSUtils.readPESHeader(pesBuffer, start);
        int leading = 0;
        if (this.predFileStart != start) {
            leading += (int)(start - this.predFileStart);
        }
        this.predFileStart = start + (long)pesLen;
        this.savePESMeta(stream, MPSIndex.makePESToken(leading, pesLen, pesBuffer.remaining()));
        this.getAnalyser(stream).pkt(pesBuffer, pesHeader);
    }

    public static void main(String[] args) throws IOException {
        MPSIndexer indexer = new MPSIndexer();
        indexer.index(new File(args[0]), new NIOUtils.FileReaderListener(){

            @Override
            public void progress(int percentDone) {
                System.out.println(percentDone);
            }
        });
        ByteBuffer index = ByteBuffer.allocate(65536);
        indexer.serialize().serializeTo(index);
        NIOUtils.writeTo(index, new File(args[1]));
    }
}

