/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jcodec.common.Assert;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mps.MPEGDemuxer;
import org.jcodec.containers.mps.MPSDemuxer;

public class MTSDemuxer
implements MPEGDemuxer {
    private MPSDemuxer psDemuxer;
    private SeekableByteChannel tsChannel;

    public static Set<Integer> getPrograms(SeekableByteChannel src) throws IOException {
        MTSPacket pkt;
        long rem = src.position();
        HashSet<Integer> guids = new HashSet<Integer>();
        for (int i = 0; (guids.size() == 0 || i < guids.size() * 500) && (pkt = MTSDemuxer.readPacket(src)) != null; ++i) {
            if (pkt.payload == null) continue;
            ByteBuffer payload = pkt.payload;
            if (guids.contains(pkt.pid) || (payload.duplicate().getInt() & 0xFFFFFF00) != 256) continue;
            guids.add(pkt.pid);
        }
        src.position(rem);
        return guids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getPrograms(File file) throws IOException {
        FileChannelWrapper fc = null;
        try {
            fc = NIOUtils.readableFileChannel(file);
            Set<Integer> set = MTSDemuxer.getPrograms(fc);
            return set;
        }
        finally {
            NIOUtils.closeQuietly(fc);
        }
    }

    public MTSDemuxer(SeekableByteChannel src, int filterGuid) throws IOException {
        this.tsChannel = new TSChannel(src, filterGuid);
        this.psDemuxer = new MPSDemuxer(this.tsChannel);
    }

    @Override
    public List<? extends MPEGDemuxer.MPEGDemuxerTrack> getTracks() {
        return this.psDemuxer.getTracks();
    }

    @Override
    public List<? extends MPEGDemuxer.MPEGDemuxerTrack> getVideoTracks() {
        return this.psDemuxer.getVideoTracks();
    }

    @Override
    public List<? extends MPEGDemuxer.MPEGDemuxerTrack> getAudioTracks() {
        return this.psDemuxer.getAudioTracks();
    }

    public static MTSPacket readPacket(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(188);
        if (NIOUtils.read(channel, buffer) != 188) {
            return null;
        }
        buffer.flip();
        return MTSDemuxer.parsePacket(buffer);
    }

    public static MTSPacket parsePacket(ByteBuffer buffer) {
        int marker = buffer.get() & 0xFF;
        Assert.assertEquals(71, marker);
        short guidFlags = buffer.getShort();
        int guid = guidFlags & 0x1FFF;
        int payloadStart = guidFlags >> 14 & 1;
        int b0 = buffer.get() & 0xFF;
        int counter = b0 & 0xF;
        if ((b0 & 0x20) != 0) {
            int taken = 0;
            taken = (buffer.get() & 0xFF) + 1;
            NIOUtils.skip(buffer, taken - 1);
        }
        return new MTSPacket(guid, payloadStart == 1, (b0 & 0x10) != 0 ? buffer : null);
    }

    public static int probe(ByteBuffer b) {
        int[] keys;
        IntObjectMap streams = new IntObjectMap();
        try {
            MTSPacket tsPkt;
            ByteBuffer sub;
            while ((sub = NIOUtils.read(b, 188)).remaining() >= 188 && (tsPkt = MTSDemuxer.parsePacket(sub)) != null) {
                ArrayList<ByteBuffer> data = (ArrayList<ByteBuffer>)streams.get(tsPkt.pid);
                if (data == null) {
                    data = new ArrayList<ByteBuffer>();
                    streams.put(tsPkt.pid, data);
                }
                if (tsPkt.payload == null) continue;
                data.add(tsPkt.payload);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        int maxScore = 0;
        for (int i : keys = streams.keys()) {
            int score = MPSDemuxer.probe(NIOUtils.combine((Iterable)streams.get(i)));
            if (score <= maxScore) continue;
            maxScore = score;
        }
        return maxScore;
    }

    @Override
    public void seekByte(long offset) throws IOException {
        this.tsChannel.position(offset - offset % 188L);
        this.psDemuxer.reset();
    }

    public static class MTSPacket {
        public ByteBuffer payload;
        public boolean payloadStart;
        public int pid;

        public MTSPacket(int guid, boolean payloadStart, ByteBuffer payload) {
            this.pid = guid;
            this.payloadStart = payloadStart;
            this.payload = payload;
        }
    }

    private static class TSChannel
    implements SeekableByteChannel {
        private SeekableByteChannel src;
        private ByteBuffer data;
        private int filterGuid;

        public TSChannel(SeekableByteChannel source, int filterGuid) {
            this.src = source;
            this.filterGuid = filterGuid;
        }

        @Override
        public boolean isOpen() {
            return this.src.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.src.close();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            while (this.data == null || !this.data.hasRemaining()) {
                MTSPacket packet = this.getPacket(this.src);
                if (packet == null) {
                    return -1;
                }
                this.data = packet.payload;
            }
            int toRead = Math.min(dst.remaining(), this.data.remaining());
            dst.put(NIOUtils.read(this.data, toRead));
            return toRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() throws IOException {
            return this.src.position();
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.src.position(newPosition);
            this.data = null;
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.src.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            return this.src.truncate(size);
        }

        protected MTSPacket getPacket(ReadableByteChannel channel) throws IOException {
            MTSPacket pkt;
            do {
                if ((pkt = MTSDemuxer.readPacket(channel)) != null) continue;
                return null;
            } while (pkt.pid <= 15 || pkt.pid == 8191 || pkt.payload == null);
            while (pkt.pid != this.filterGuid) {
                pkt = MTSDemuxer.readPacket(channel);
                if (pkt != null) continue;
                return null;
            }
            return pkt;
        }
    }
}

