/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Header;

public class EndianBox
extends Box {
    private Endian endian;

    public EndianBox(Box other) {
        super(other);
    }

    public static String fourcc() {
        return "enda";
    }

    public EndianBox(Header header) {
        super(header);
    }

    public EndianBox(Endian endian) {
        super(new Header(EndianBox.fourcc()));
        this.endian = endian;
    }

    @Override
    public void parse(ByteBuffer input) {
        long end = input.getShort();
        this.endian = end == 1L ? Endian.LITTLE_ENDIAN : Endian.BIG_ENDIAN;
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.putShort((short)(this.endian == Endian.LITTLE_ENDIAN ? 1 : 0));
    }

    public Endian getEndian() {
        return this.endian;
    }

    protected int calcSize() {
        return 2;
    }

    public static enum Endian {
        LITTLE_ENDIAN,
        BIG_ENDIAN;

    }
}

