plugins {
	id("junitbuild.java-library-conventions")
	id("junitbuild.java-nullability-conventions")
	`java-test-fixtures`
}

description = "JUnit Platform Launcher"

dependencies {
	api(platform(projects.junitBom))
	api(projects.junitPlatformEngine)

	compileOnlyApi(libs.apiguardian)
	compileOnlyApi(libs.jspecify)

	osgiVerification(projects.junitJupiterEngine)
}

javadocConventions {
	addExtraModuleReferences(projects.junitPlatformReporting)
}

tasks {
	jar {
		bundle {
			val importAPIGuardian: String by extra
			val importJSpecify: String by extra
			val importCommonsLogging: String by extra
			val version = project.version
			bnd("""
				Import-Package: \
					${importAPIGuardian},\
					${importJSpecify},\
					${importCommonsLogging},\
					jdk.jfr;resolution:="optional",\
					*
				Provide-Capability:\
					org.junit.platform.launcher;\
						org.junit.platform.launcher='junit-platform-launcher';\
						version:Version="${'$'}{version_cleanup;${version}}"
			""")
		}
	}
}
