/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.print;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PageSize {
    private final double height;
    private final double width;
    public static final PageSize ISO_A4 = new PageSize(29.7, 21.0);
    public static final PageSize US_LEGAL = new PageSize(35.56, 21.59);
    public static final PageSize ANSI_TABLOID = new PageSize(43.18, 27.94);
    public static final PageSize US_LETTER = new PageSize(27.94, 21.59);

    public PageSize() {
        this(ISO_A4.getHeight(), ISO_A4.getWidth());
    }

    public PageSize(double height, double width) {
        this.height = height;
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public static PageSize setPageSize(PageSize pageSize) {
        if (pageSize == null) {
            throw new IllegalArgumentException("Page size cannot be null");
        }
        return new PageSize(pageSize.getHeight(), pageSize.getWidth());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> options = new HashMap<String, Object>(7);
        options.put("height", this.getHeight());
        options.put("width", this.getWidth());
        return options;
    }

    public String toString() {
        return "PageSize[width=" + this.getWidth() + ", height=" + this.getHeight() + "]";
    }
}

