/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.bidi.network.BytesValue;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.bidi.network.SetCookieHeader;

public class ProvideResponseParameters {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public ProvideResponseParameters(String request) {
        this.map.put("request", request);
    }

    public ProvideResponseParameters body(BytesValue value) {
        this.map.put("body", value.toMap());
        return this;
    }

    public ProvideResponseParameters cookies(List<SetCookieHeader> cookieHeaders) {
        List cookies = cookieHeaders.stream().map(SetCookieHeader::toMap).collect(Collectors.toList());
        this.map.put("cookies", cookies);
        return this;
    }

    public ProvideResponseParameters headers(List<Header> headers) {
        List headerList = headers.stream().map(Header::toMap).collect(Collectors.toList());
        this.map.put("headers", headerList);
        return this;
    }

    public ProvideResponseParameters reasonPhrase(String reasonPhrase) {
        this.map.put("reasonPhrase", reasonPhrase);
        return this;
    }

    public ProvideResponseParameters statusCode(int statusCode) {
        this.map.put("statusCode", statusCode);
        return this;
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.map);
    }
}

