/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Internal;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

@Internal
public class EditorialCostForMapping {
    public static int baseEditorialCostForMapping(Mapping mapping, SchemaGraph sourceGraph, SchemaGraph targetGraph) {
        return EditorialCostForMapping.baseEditorialCostForMapping(mapping, sourceGraph, targetGraph, new ArrayList<EditOperation>());
    }

    public static int baseEditorialCostForMapping(Mapping mapping, SchemaGraph sourceGraph, SchemaGraph targetGraph, List<EditOperation> editOperationsResult) {
        int cost = 0;
        for (int i = 0; i < mapping.size(); ++i) {
            boolean equalNodes;
            Vertex sourceVertex = mapping.getSource(i);
            Vertex targetVertex = mapping.getTarget(i);
            boolean bl = equalNodes = sourceVertex.getType().equals(targetVertex.getType()) && sourceVertex.getProperties().equals(targetVertex.getProperties());
            if (equalNodes) continue;
            if (sourceVertex.isIsolated()) {
                editOperationsResult.add(EditOperation.insertVertex("Insert" + String.valueOf(targetVertex), sourceVertex, targetVertex));
            } else if (targetVertex.isIsolated()) {
                editOperationsResult.add(EditOperation.deleteVertex("Delete " + String.valueOf(sourceVertex), sourceVertex, targetVertex));
            } else {
                editOperationsResult.add(EditOperation.changeVertex("Change " + String.valueOf(sourceVertex) + " to " + String.valueOf(targetVertex), sourceVertex, targetVertex));
            }
            ++cost;
        }
        for (Edge sourceEdge : sourceGraph.getEdges()) {
            Vertex targetTo;
            if (!mapping.containsSource(sourceEdge.getFrom()) || !mapping.containsSource(sourceEdge.getTo())) continue;
            Vertex targetFrom = mapping.getTarget(sourceEdge.getFrom());
            Edge targetEdge = targetGraph.getEdge(targetFrom, targetTo = mapping.getTarget(sourceEdge.getTo()));
            if (targetEdge == null) {
                editOperationsResult.add(EditOperation.deleteEdge("Delete edge " + String.valueOf(sourceEdge), sourceEdge));
                ++cost;
                continue;
            }
            if (sourceEdge.getLabel().equals(targetEdge.getLabel())) continue;
            editOperationsResult.add(EditOperation.changeEdge("Change " + String.valueOf(sourceEdge) + " to " + String.valueOf(targetEdge), sourceEdge, targetEdge));
            ++cost;
        }
        for (Edge targetEdge : targetGraph.getEdges()) {
            Vertex sourceTo;
            Vertex sourceFrom;
            if (!mapping.containsTarget(targetEdge.getFrom()) || !mapping.containsTarget(targetEdge.getTo()) || sourceGraph.getEdge(sourceFrom = mapping.getSource(targetEdge.getFrom()), sourceTo = mapping.getSource(targetEdge.getTo())) != null) continue;
            editOperationsResult.add(EditOperation.insertEdge("Insert edge " + String.valueOf(targetEdge), targetEdge));
            ++cost;
        }
        return cost;
    }

    public static int editorialCostForMapping(int baseCost, Mapping mapping, SchemaGraph sourceGraph, SchemaGraph targetGraph) {
        AtomicInteger cost = new AtomicInteger(baseCost);
        LinkedHashSet seenEdges = new LinkedHashSet();
        Predicate<Edge> visitEdge = data -> {
            if (seenEdges.contains(data)) {
                return false;
            }
            seenEdges.add(data);
            return true;
        };
        mapping.forEachNonFixedSourceAndTarget((sourceVertex, targetVertex) -> {
            boolean equalNodes;
            boolean bl = equalNodes = sourceVertex.getType().equals(targetVertex.getType()) && sourceVertex.getProperties().equals(targetVertex.getProperties());
            if (!equalNodes) {
                cost.getAndIncrement();
            }
            for (Edge sourceEdge : sourceGraph.getAdjacentEdgesAndInverseNonCopy((Vertex)sourceVertex)) {
                Vertex targetTo;
                if (!visitEdge.test(sourceEdge) || !mapping.containsSource(sourceEdge.getFrom()) || !mapping.containsSource(sourceEdge.getTo())) continue;
                Vertex targetFrom = mapping.getTarget(sourceEdge.getFrom());
                Edge targetEdge = targetGraph.getEdge(targetFrom, targetTo = mapping.getTarget(sourceEdge.getTo()));
                if (targetEdge == null) {
                    cost.getAndIncrement();
                    continue;
                }
                if (sourceEdge.getLabel().equals(targetEdge.getLabel())) continue;
                cost.getAndIncrement();
            }
            for (Edge targetEdge : targetGraph.getAdjacentEdgesAndInverseNonCopy((Vertex)targetVertex)) {
                Vertex sourceTo;
                Vertex sourceFrom;
                Edge sourceEdge;
                if (!visitEdge.test(targetEdge) || !mapping.containsTarget(targetEdge.getFrom()) || !mapping.containsTarget(targetEdge.getTo()) || (sourceEdge = sourceGraph.getEdge(sourceFrom = mapping.getSource(targetEdge.getFrom()), sourceTo = mapping.getSource(targetEdge.getTo()))) != null) continue;
                cost.getAndIncrement();
            }
        });
        return cost.get();
    }
}

