/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collector;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.json.JsonInput;

public class CapabilityCount {
    private final Map<Capabilities, Integer> counts;

    public CapabilityCount(Map<Capabilities, Integer> counts) {
        this.counts = Collections.unmodifiableMap(new HashMap<Capabilities, Integer>(counts));
    }

    public Map<Capabilities, Integer> getCounts() {
        return this.counts;
    }

    private Object toJson() {
        return this.counts.entrySet().stream().map(entry -> {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("capabilities", entry.getKey());
            toReturn.put("count", entry.getValue());
            return toReturn;
        }).collect(Collector.of(ArrayList::new, ArrayList::add, (l, r) -> {
            l.addAll(r);
            return l;
        }, Collections::unmodifiableList, Collector.Characteristics.UNORDERED));
    }

    private static CapabilityCount fromJson(JsonInput input) {
        HashMap<Capabilities, Integer> toReturn = new HashMap<Capabilities, Integer>();
        input.beginArray();
        while (input.hasNext()) {
            Capabilities caps = null;
            int count = 0;
            input.beginObject();
            block9: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "capabilities": {
                        caps = (Capabilities)input.read((Type)((Object)Capabilities.class));
                        continue block9;
                    }
                    case "count": {
                        count = input.nextNumber().intValue();
                        continue block9;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            toReturn.put(caps, count);
        }
        input.endArray();
        return new CapabilityCount(toReturn);
    }
}

