/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps.psi;

import java.nio.ByteBuffer;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.IntIntMap;
import org.jcodec.containers.mps.psi.PSISection;

public class PATSection
extends PSISection {
    private int[] networkPids;
    private IntIntMap programs;

    public PATSection(PSISection psi, int[] networkPids, IntIntMap programs) {
        super(psi);
        this.networkPids = networkPids;
        this.programs = programs;
    }

    public int[] getNetworkPids() {
        return this.networkPids;
    }

    public IntIntMap getPrograms() {
        return this.programs;
    }

    public static PATSection parse(ByteBuffer data) {
        PSISection psi = PSISection.parse(data);
        IntArrayList networkPids = new IntArrayList();
        IntIntMap programs = new IntIntMap();
        while (data.remaining() > 4) {
            int programNum = data.getShort() & 0xFFFF;
            short w = data.getShort();
            int pid = w & 0x1FFF;
            if (programNum == 0) {
                networkPids.add(pid);
                continue;
            }
            programs.put(programNum, pid);
        }
        return new PATSection(psi, networkPids.toArray(), programs);
    }
}

