/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodec.common.StringUtils;

public class MainUtils {
    private static final String JCODEC_LOG_SINK_COLOR = "jcodec.colorPrint";
    public static boolean isColorSupported = System.console() != null || Boolean.parseBoolean(System.getProperty("jcodec.colorPrint"));
    private static Pattern flagPattern = Pattern.compile("^--([^=]+)=(.*)$");

    public static Cmd parseArguments(String[] args) {
        int firstArg;
        HashMap<String, String> flags = new HashMap<String, String>();
        for (firstArg = 0; firstArg < args.length; ++firstArg) {
            if (args[firstArg].startsWith("--")) {
                Matcher matcher = flagPattern.matcher(args[firstArg]);
                if (matcher.matches()) {
                    flags.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                flags.put(args[firstArg].substring(2), "true");
                continue;
            }
            if (!args[firstArg].startsWith("-")) break;
            flags.put(args[firstArg].substring(1), args[++firstArg]);
        }
        return new Cmd(flags, Arrays.copyOfRange(args, firstArg, args.length));
    }

    public static void printHelp(Map<String, String> flags, String ... params) {
        System.out.print(MainUtils.bold("Syntax:"));
        StringBuilder sample = new StringBuilder();
        StringBuilder detail = new StringBuilder();
        for (Map.Entry<String, String> entry : flags.entrySet()) {
            sample.append(" [" + MainUtils.bold(MainUtils.color("--" + entry.getKey() + "=<value>", ANSIColor.MAGENTA)) + "]");
            detail.append("\t" + MainUtils.bold(MainUtils.color("--" + entry.getKey(), ANSIColor.MAGENTA)) + "\t\t" + entry.getValue() + "\n");
        }
        for (String string : params) {
            sample.append(MainUtils.bold(" <" + string + ">"));
        }
        System.out.println(sample);
        System.out.println(MainUtils.bold("Where:"));
        System.out.println(detail);
    }

    public static String bold(String str) {
        return isColorSupported ? "\u001b[1m" + str + "\u001b[0m" : str;
    }

    public static String colorString(String str, String placeholder) {
        return isColorSupported ? "\u001b[" + placeholder + "m" + str + "\u001b[0m" : str;
    }

    public static String color(String str, ANSIColor fg) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + "m" + str + "\u001b[0m" : str;
    }

    public static String color(String str, ANSIColor fg, boolean bright) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (bright ? 1 : 2) + "m" + str + "\u001b[0m" : str;
    }

    public static String color(String str, ANSIColor fg, ANSIColor bg) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (40 + (bg.ordinal() & 7)) + ";1m" + str + "\u001b[0m" : str;
    }

    public static String color(String str, ANSIColor fg, ANSIColor bg, boolean bright) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (40 + (bg.ordinal() & 7)) + ";" + (bright ? 1 : 2) + "m" + str + "\u001b[0m" : str;
    }

    public static enum ANSIColor {
        BLACK,
        RED,
        GREEN,
        BROWN,
        BLUE,
        MAGENTA,
        CYAN,
        GREY;

    }

    public static class Cmd {
        public Map<String, String> flags;
        public String[] args;

        public Cmd(Map<String, String> flags, String[] args) {
            this.flags = flags;
            this.args = args;
        }

        public Long getLongFlag(String flagName, Long defaultValue) {
            return this.flags.containsKey(flagName) ? new Long(this.flags.get(flagName)) : defaultValue;
        }

        public Integer getIntegerFlag(String flagName, Integer defaultValue) {
            return this.flags.containsKey(flagName) ? new Integer(this.flags.get(flagName)) : defaultValue;
        }

        public Boolean getBooleanFlag(String flagName, Boolean defaultValue) {
            return this.flags.containsKey(flagName) ? new Boolean(this.flags.get(flagName)) : defaultValue;
        }

        public Double getDoubleFlag(String flagName, Long defaultValue) {
            return this.flags.containsKey(flagName) ? new Double(this.flags.get(flagName)) : (double)defaultValue.longValue();
        }

        public String getStringFlag(String flagName, String defaultValue) {
            return this.flags.containsKey(flagName) ? this.flags.get(flagName) : defaultValue;
        }

        public int[] getMultiIntegerFlag(String flagName, int[] defaultValue) {
            if (!this.flags.containsKey(flagName)) {
                return defaultValue;
            }
            String[] split = StringUtils.split(this.flags.get(flagName), ",");
            int[] result = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                result[i] = Integer.parseInt(split[i]);
            }
            return result;
        }

        public Long getLongFlag(String flagName) {
            return this.getLongFlag(flagName, null);
        }

        public Integer getIntegerFlag(String flagName) {
            return this.getIntegerFlag(flagName, null);
        }

        public Boolean getBooleanFlag(String flagName) {
            return this.getBooleanFlag(flagName, null);
        }

        public Double getDoubleFlag(String flagName) {
            return this.getDoubleFlag(flagName, null);
        }

        public String getStringFlag(String flagName) {
            return this.getStringFlag(flagName, null);
        }

        public int[] getMultiIntegerFlag(String flagName) {
            return this.getMultiIntegerFlag(flagName, new int[0]);
        }

        public String getArg(int i) {
            return i < this.args.length ? this.args[i] : null;
        }

        public int argsLength() {
            return this.args.length;
        }
    }
}

